// ---------------------------------------------------------------------------

typedef struct {
  u32 ModelIndex;
  double Score;
} TModelResult;

static u32 ModelResultsCount;
static TModelResult *pModelResults;

static u32 ModelResults_MouseTag;

static void ModelResults_Init(void)
{
  ModelResultsCount=0;
  pModelResults=0;
  
  ModelResults_MouseTag=(u32)-1;
}

static void ModelResults_Clear(void)
{
  ModelResultsCount=0;
  if(pModelResults!=NULL){
    safefree(&MM_SKKOSKHW,pModelResults); pModelResults=NULL;
  }
}

static void ModelResults_Add(u32 ModelIndex,double Score)
{
  TModelResult *pmr=NULL;
  
//  _consolePrintf("Add: %d WC=$%04x Score=%f.\n",ModelIndex,pModels[ModelIndex].wc,Score);
  
  for(u32 idx=0;idx<ModelResultsCount;idx++){
    TModelResult *p=&pModelResults[idx];
    if(pModels[p->ModelIndex].wc==pModels[ModelIndex].wc) pmr=p;
  }
  
  if(pmr==NULL){
    pModelResults=(TModelResult*)saferealloc(&MM_SKKOSKHW,pModelResults,sizeof(TModelResult)*(ModelResultsCount+1));
    pmr=&pModelResults[ModelResultsCount++];
    pmr->ModelIndex=ModelIndex;
    pmr->Score=-10000;
  }
  
  if(pmr->Score<Score) pmr->Score=Score;
}

static void ModelResults_Sort(void)
{
  if(ModelResultsCount<=1) return;
  
  for(u32 idx1=0;idx1<ModelResultsCount-1;idx1++){
    for(u32 idx2=idx1+1;idx2<ModelResultsCount;idx2++){
      if(pModelResults[idx1].Score<pModelResults[idx2].Score){
        TModelResult tmp=pModelResults[idx1];
        pModelResults[idx1]=pModelResults[idx2];
        pModelResults[idx2]=tmp;
      }
    }
  }
  
  if(false){
    for(u32 mridx=0;mridx<ModelResultsCount;mridx++){
      TModelResult *pmr=&pModelResults[mridx];
      UnicodeChar wc=pModels[pmr->ModelIndex].wc;
      _consolePrintf("Sort: %d WC=$%04x Score=%f.\n",mridx,wc,pmr->Score);
    }
  }
}

static UnicodeChar ModelResults_GetChar_ins_Apply(UnicodeChar wc,bool KogakiFlag)
{
  if(OSKHW_CharMode_UseNumber==true){
  }
  
  if(OSKHW_CharMode==OSKHW_CM_Symbol){
    if((wc==/*[*/ 0x30fc)||(wc==/*-*/ 0x002d)){
      if(KogakiFlag==true){
        wc=/*_*/ 0x005F;
        }else{
        wc=/*-*/ 0x002d;
      }
    }
    if((wc==/*`*/ 0xff5e)||(wc==/*~*/ 0x007e)) wc=/*`*/ 0xff5e;
  }
  
  if(OSKHW_CharMode==OSKHW_CM_ENG_Large){
  }
  if(OSKHW_CharMode==OSKHW_CM_ENG_Small){
  }
  if((OSKHW_CharMode==OSKHW_CM_ENG_Large)||(OSKHW_CharMode==OSKHW_CM_ENG_Small)){
    if((wc==/*[*/ 0x30fc)||(wc==/*-*/ 0x002d)){
      if(KogakiFlag==true){
        wc=/*_*/ 0x005F;
        }else{
        wc=/*-*/ 0x002d;
      }
    }
    if((wc==/*`*/ 0xff5e)||(wc==/*~*/ 0x007e)) wc=/*`*/ 0xff5e;
  }
  
  if(OSKHW_CharMode==OSKHW_CM_JPN_Hiragana){
  }
  if(OSKHW_CharMode==OSKHW_CM_JPN_Katakana){
  }
  if((OSKHW_CharMode==OSKHW_CM_JPN_Hiragana)||(OSKHW_CharMode==OSKHW_CM_JPN_Katakana)){
    if((wc==/*[*/ 0x30fc)||(wc==/*-*/ 0x002d)) wc=/*[*/ 0x30fc;
    if((wc==/*`*/ 0xff5e)||(wc==/*~*/ 0x007e)) wc=/*`*/ 0xff5e;
    if((wc==/*,*/ 0x002c)||(wc==/*.*/ 0x002e)) wc=/*A*/ 0x3001;
    if(KogakiFlag==true){
      if(wc==/**/ 0x3042) wc=/**/ 0x3041;
      if(wc==/**/ 0x3044) wc=/**/ 0x3043;
      if(wc==/**/ 0x3046) wc=/**/ 0x3045;
      if(wc==/**/ 0x3048) wc=/**/ 0x3047;
      if(wc==/**/ 0x304a) wc=/**/ 0x3049;
      if(wc==/**/ 0x3064) wc=/**/ 0x3063;
      if(wc==/**/ 0x3084) wc=/**/ 0x3083;
      if(wc==/**/ 0x3086) wc=/**/ 0x3085;
      if(wc==/**/ 0x3088) wc=/**/ 0x3087;
      if(wc==/*A*/ 0x30a2) wc=/*@*/ 0x30a1;
      if(wc==/*C*/ 0x30a4) wc=/*B*/ 0x30a3;
      if(wc==/*E*/ 0x30a6) wc=/*D*/ 0x30a5;
      if(wc==/*G*/ 0x30a8) wc=/*F*/ 0x30a7;
      if(wc==/*I*/ 0x30aa) wc=/*H*/ 0x30a9;
      if(wc==/*c*/ 0x30c4) wc=/*b*/ 0x30c3;
      if(wc==/**/ 0x30e4) wc=/**/ 0x30e3;
      if(wc==/**/ 0x30e6) wc=/**/ 0x30e5;
      if(wc==/**/ 0x30e8) wc=/**/ 0x30e7;
    }
  }
  
  return(wc);
}

static UnicodeChar ModelResults_GetChar(u32 ResultsIndex,bool KogakiFlag)
{
  if(ResultsIndex==(u32)-1){
    if(ModelResultsCount==0) return(0);
    ResultsIndex=0;
  }
  
  if(ModelResultsCount<=ResultsIndex) StopFatalError(0,"Index overflow. (%d<=%d)\n",ModelResultsCount,ResultsIndex);
  
  u32 midx=pModelResults[ResultsIndex].ModelIndex;
  UnicodeChar wc=pModels[midx].wc;
  
  wc=ModelResults_GetChar_ins_Apply(wc,KogakiFlag);
  
  return(wc);
}

static const s32 ModelResults_WinWidth=32;
static const s32 ModelResults_WinLeft=(ScreenWidth/2)+4-(ModelResults_WinWidth/2);
static const s32 ModelResults_WinTop=32;

static void DrawFrame(CglCanvas *pcan,s32 x,s32 y,s32 w,s32 h,u16 FrameColor,u16 BGColor)
{
  pcan->SetColor(BGColor);
  pcan->FillBox(x,y,w,h);
  pcan->SetColor(FrameColor);
  pcan->DrawBox(x,y,w,h);
}

static void DrawFrameTextA(CglCanvas *pcan,s32 x,s32 y,s32 w,s32 h,const char *pstr,u16 TextColor)
{
  x+=w/2;
  y+=h/2;
  
  u16 tw=pcan->GetTextWidthA(pstr),th=glCanvasTextHeight;
  x-=tw/2;
  y-=th/2;
  
  pcan->SetFontTextColor(TextColor);
  pcan->TextOutA(x,y,pstr);
}

static void DrawFrameTextWC(CglCanvas *pcan,s32 x,s32 y,s32 w,s32 h,UnicodeChar wc,u16 TextColor)
{
  x+=w/2;
  y+=h/2;
  
  const UnicodeChar str[2]={wc,0};
  
  u16 tw=pcan->GetTextWidthW(str),th=glCanvasTextHeight;
  x-=tw/2;
  y-=th/2;
  
  pcan->SetFontTextColor(TextColor);
  pcan->TextOutW(x,y,str);
}

static void DrawFrameTGF(CglCanvas *pcan,s32 x,s32 y,s32 w,s32 h,CglTGF *ptgf)
{
  x+=w/2;
  y+=h/2;
  
  x-=ptgf->GetWidth()/2;
  y-=ptgf->GetHeight()/2;
  
  ptgf->BitBlt(pcan,x,y);
}

static void ModelResults_DrawPreview(CglCanvas *pcan,bool KogakiFlag)
{
  UnicodeChar wc=ModelResults_GetChar((u32)-1,KogakiFlag);
  if(wc==0) return;
  
  s32 x=ModelResults_WinLeft,y=ModelResults_WinTop;
  s32 w=24,h=24;
  u16 FrameColor=RGB15(0,0,0)|BIT15;
  u16 BGColor=0,BGColorNormal=RGB15(31,31,31)|BIT15,BGColorHigh=RGB15(24,31,24)|BIT15;
  
  BGColor=BGColorNormal;
  if(ModelResults_MouseTag==0) BGColor=BGColorHigh;
  DrawFrame(pcan,x,y,w,h,FrameColor,BGColor);
  DrawFrameTGF(pcan,x,y,w,h,pSkinOSKHW_OK);
  
  y+=h;
  
  BGColor=BGColorNormal;
  if(ModelResults_MouseTag==1) BGColor=BGColorHigh;
  DrawFrame(pcan,x,y,w,h,FrameColor,BGColor);
  DrawFrameTextWC(pcan,x,y,w,h,wc,RGB15(0,0,0)|BIT15);
  
  y+=h+8;
  y+=32;
  
  BGColor=BGColorNormal;
  if(ModelResults_MouseTag==2) BGColor=BGColorHigh;
  DrawFrame(pcan,x,y,w,h,FrameColor,BGColor);
  DrawFrameTGF(pcan,x,y,w,h,pSkinOSKHW_NG);
}

// -------------------------------------------------------------------------------------

static bool ModelResults_MouseFlag=false;
static bool ModelResults_KogakiFlag;
static UnicodeChar ModelResults_SelectResult;

#include "OSKHW_Model_ModelResults_Selector.h"

static u32 ModelResults_GetMouseTag(s32 mx,s32 my)
{
  u32 tag=(u32)-1;
  
  s32 x=ModelResults_WinLeft,y=ModelResults_WinTop;
  s32 w=24,h=24;
  
  if((x<=mx)&&(mx<(x+w))&&(y<=my)&&(my<(y+h))) tag=0;
  
  y+=h;
  
  if((x<=mx)&&(mx<(x+w))&&(y<=my)&&(my<(y+h))) tag=1;
  
  y+=h+8;
  y+=32;
  
  if((x<=mx)&&(mx<(x+w))&&(y<=my)&&(my<(y+h))) tag=2;
  
  return(tag);
}

static bool ModelResults_MouseDown(s32 mx,s32 my,TModel *pUserFitModel,bool KogakiFlag)
{
  ModelResults_MouseTag=(u32)-1;
  
  ModelResults_KogakiFlag=KogakiFlag;
  
  ModelResults_SelectResult=0;
  
  UnicodeChar wc=ModelResults_GetChar((u32)-1,ModelResults_KogakiFlag);
  if(wc==0) return(false);
  
  u32 tag=ModelResults_GetMouseTag(mx,my);
  
  if(tag!=(u32)-1){
    ModelResults_MouseTag=tag;
    switch(ModelResults_MouseTag){
      case 0: case 1: { // OK{^ƕ{^
        ModelResults_DrawPreview(pScreenMainOverlay->pCanvas,ModelResults_KogakiFlag);
      } break;
      case 2: { // MՓo^{^
        ModelResults_SelectResult=Selector_Execute(pUserFitModel);
        ModelResults_MouseTag=(u32)-1;
      } break;
    }
    ModelResults_MouseFlag=true;
    return(true);
  }
  
  return(false);
}

static bool ModelResults_MouseMove(s32 mx,s32 my)
{
  if(ModelResults_MouseFlag==false) return(false);
  
  if(ModelResults_MouseTag==(u32)-1) return(true);
  
  u32 tag=ModelResults_GetMouseTag(mx,my);
  
  if(ModelResults_MouseTag!=tag){
    ModelResults_MouseTag=(u32)-1;
  }
  
  ModelResults_DrawPreview(pScreenMainOverlay->pCanvas,ModelResults_KogakiFlag);
  
  return(true);
}

static bool ModelResults_MouseUp(s32 mx,s32 my,UnicodeChar *pwc)
{
  if(ModelResults_MouseFlag==false) return(false);
  ModelResults_MouseFlag=false;
  
  if(ModelResults_MouseTag==(u32)-1){
    *pwc=0;
    if(ModelResults_SelectResult!=0) *pwc=ModelResults_SelectResult;
    return(true);
  }
  
  switch(ModelResults_MouseTag){
    case 0: case 1: { // OK{^ƕ{^
      *pwc=ModelResults_GetChar((u32)-1,ModelResults_KogakiFlag);
    } break;
    case 2: { // MՓo^{^
      *pwc=0;
    } break;
  }
  
  ModelResults_MouseTag=(u32)-1;
  ModelResults_DrawPreview(pScreenMainOverlay->pCanvas,ModelResults_KogakiFlag);
  
  return(true);
}

